<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once($APPBASE."config/TransformConfig.php");


// This is your project-spefic service.
// Must inherit XperDbService.
class TransformDbService extends XperDbService
{
    function GetEvent($scr, $eventid, &$row)
    {
        //$eventid = 2707;
        // If bypass_dates is Yes, include a larger date range.
        $sql = 'select * from xperdev_data_transformations.Event where Event_Id = :eventid limit 1';

        $retval = $this->Execute($sql, Array('eventid' => $eventid), $rows);
        if ($retval)
            $row = $rows[0];
            
echo "Processing Single " . $eventid;
//die("died");

        return $retval;
    }


    function GetEventsForTransform($scr, &$rows)
    {
        // If bypass_dates is Yes, include a larger date range.
        $sql = "
            select E.*, T.Tour_Id, T.Tour_Name
                from xperdev_data_transformations.Event E
                    join xperdev_data_transformations.Tour_Event TE on E.event_id = TE.event_id
                    join xperdev_data_transformations.Tour T on TE.tour_id = T.tour_id
                where
                    E.Active = 1 
                    
                    and E.Event_DB is not null and E.Event_DB <> '' and E.Event_DB <> 'xperdev_test'
                    and E.Table_name is not null and E.Table_Name <> ''
                    
                    and
                    
                    (
                        (E.bypass_dates = 'N' and E.Event_End > DATE_SUB(NOW(), INTERVAL 60 DAY) and E.Active < 3)
                        or
                        (E.bypass_dates = 'Y' and E.Event_End > DATE_SUB(NOW(), INTERVAL 60 DAY) and E.Active < 3)
                    )
                order by
                    E.event_id desc
                ";

        // Removed this from the where clause 8/28/19
        // (E.bypass_dates = 'N' and E.Event_End > DATE_SUB(NOW(), INTERVAL 60 DAY) and E.Event_Start < DATE_ADD(NOW(), INTERVAL 10 DAY) and E.Active < 3)

        return $this->Execute($sql, null, $rows);
    }


    function GetTourTableRegsCount($scr, $eventid, $tourdb, $tourtable, &$count)
    {
        $sql = "
       
                    
                     
        select count(*) as RowCount
                from
                    $tourdb.$tourtable
                where
                    event_id = :eventid
                    and data like '%}first%'
                    and active=1
                    and id not in
                    (
                        select distinct table_id
                            from xperdev_data_transformations.2015_registration_data
                            where event_id = :eventid
                    )
            ";

        $parms = Array('eventid' => $eventid);

        $retval = $this->Execute($sql, $parms, $rows);
 
        $count = $rows[0]["RowCount"];
 

        return $retval;
    }


    function GetTourTableRegs($scr, $eventid, $tourdb, $tourtable, &$rows)
    {
        global $LOG;

        $sql = "
            select *
                from
                    $tourdb.$tourtable
                where
                    event_id = :eventid
                    and data like '%}first%'
                    and active=1
                    and id not in
                    (
                        select distinct table_id
                            from xperdev_data_transformations.2015_registration_data
                            where event_id = :eventid
                    )
                order by
                    id
                    limit 150
            ";

        return $this->Execute($sql, Array('eventid' => $eventid), $rows);
    }


    function GetKeysForDedup($scr, $eventid, &$rows)
    {
/*        $sql = "
            select
	            concat(lower(event_subgroup),lower(First_Name),lower(Last_Name),lower(Email)) as DupKey,
                (select max(duplicate) from xperdev_data_transformations.2015_registration_data where event_id = RD.event_id and concat(event_subgroup,First_Name,Last_Name,Email) = DupKey) MaxDup
            from
	            xperdev_data_transformations.2015_registration_data RD
            where
	            event_id = :eventid
                and duplicate is null
            group by
	            DupKey
            ";*/
            
                    $sql = "select *, (select max(duplicate) 
                
                from xperdev_data_transformations.2015_registration_data where event_id = RD.event_id and concat(event_subgroup,First_Name,Last_Name,Email) = DupKey)  MaxDup 
            from
	           xperdev_data_transformations.dedupe_dupekey RD
            where
	            event_id = :eventid
                and duplicate is null
                
            group by
	            DupKey
            ";

        $parms = Array('eventid' => $eventid);

        $retval = $this->Execute($sql, $parms, $rows);

        return $retval;
    }


    //function GetRegsForDedupCount($scr, $eventid, &$count)
    //{
    //    $sql = "
    //        select
    //            count(*) RowCount
    //        from
    //            xperdev_data_transformations.2015_registration_data
    //        where
    //            Event_Id = :eventid
    //            and (duplicate is null or duplicate != 255)
    //    ";

    //    $retval = $this->Execute($sql, Array('eventid' => $eventid), $rows);
    //    $count = $rows[0]["RowCount"];

    //    return $retval;
    //}


    function GetRegsForDedup($scr, $eventid, $dupkey, &$rows)
    {
        $sql = "
            select
                id
            from
                xperdev_data_transformations.2015_registration_data
            where
                Event_Id = :eventid
                and duplicate is null
                and concat(lower(event_subgroup),lower(First_Name),lower(Last_Name),lower(Email)) = :dupkey
            order by
                time_in
        ";

        $parms = Array('eventid' => $eventid, 'dupkey' => $dupkey);

        $retval = $this->Execute($sql, $parms, $rows);

        return $retval;
    }


    function GetBrochureRegsCount($scr, $eventid, &$count)
    {
        $sql = "
            select
                count(*) RowCount
            from
                xperdev_data_transformations.2015_registration_data
            where
                Event_Id = :eventid
                and vehicle_of_interest is not null
                and vehicle_of_interest != ''
                and vehicle_of_interest not like '%||||%'
                and id not in (select registration_id from xperdev_data_transformations.brochure_data)
        ";

        $retval = $this->Execute($sql, Array('eventid' => $eventid), $rows);
        $count = $rows[0]["RowCount"];

        return $retval;
    }


    function GetBrochureRegs($scr, $eventid, &$offset, &$rows)
    {
        global $LOG;

        $sql = "
            select
                id, vehicle_of_interest
            from
                xperdev_data_transformations.2015_registration_data
            where
                Event_Id = :eventid
                and vehicle_of_interest is not null
                and vehicle_of_interest != ''
                and vehicle_of_interest not like '%||||%'
                and id not in (select registration_id from xperdev_data_transformations.brochure_data)
            order by
                id asc
            limit 100
            ";

        $retval = $this->Execute($sql, Array('eventid' => $eventid), $rows);
        $offset += count($rows);

        return $retval;
    }


    function InsertBrochure($scr, $id, $voi, &$newid)
    {
        $sql = "
            insert into xperdev_data_transformations.brochure_data
                (registration_id, brochure, sent)
                values
                (:id, :brochure, 0)
            ";

        return $this->ExecuteNonQuery($sql, Array('id' => $id, 'brochure' => $voi), $newid);
    }


    function UpdateRegDuplicate($scr, $id, $duplicate)
    {
        $sql = '
            update xperdev_data_transformations.2015_registration_data
                set duplicate = :duplicate
                where id = :id
            ';

        $parms =  Array('duplicate' => $duplicate, 'id' => $id);

        return $this->ExecuteNonQuery($sql, $parms, $nil);
    }


    function InsertReg($scr, $insertvals,&$newid)
    {
        $collist = '';
        $vallist = '';
        foreach ($insertvals as $key=>$val) {
            $collist .= ($collist==''?'':', ').$key;
            $vallist .= ($vallist==''?'':', ').':'.$key;
        }
        $sql = 'insert into xperdev_data_transformations.2015_registration_data ('.$collist.') values ('.$vallist.')';
       

        $retval = $this->ExecuteNonQuery($sql, $insertvals, $newid);
        die("mazdie1");

        var_dump($sql);
       var_dump("Line Break");
        var_dump($retval);

       
       
        return $retval;
    }


    function InsertOrUpdateExtraneous($scr, $id, $extravals, $newid)
    {
        $sql = "
            insert into xperdev_data_transformations.extraneous_registration_data
                (Id,extra_data)
                values
                (:id, :extra_data)
            on duplicate key update extra_data = :extra_data
            ";

        return $this->ExecuteNonQuery($sql, Array('id' => $id, 'extra_data' => $extravals), $newid);
    }


    function GetFieldMappings($scr, &$rows)
    {
        $sql = 'select * from Support.FieldMapping';

        return $this->Execute($sql, null, $rows);
    }


    function ZipCodeLookup($scr, $zip, &$rec)
    {
        $sql = "select * from Support.PostalCode where PostalCode = :zip";

        $retval = $this->Execute($sql, Array('zip' => $zip), $rows);
        $rec = ($rows ? $rows[0] : null);

        return $retval;
    }
}

?>

