<?php
// Use thits throughout the app;
$APPBASE = str_replace('\\','/',substr(__DIR__,0,strlen(__DIR__)-7)).'/';

require_once($APPBASE.'XperPhp/XperPhp.php');
require_once($APPBASE.'db/TransformDbService.php');
require_once($APPBASE.'functions/PopulateEvent.php');
require_once($APPBASE.'functions/PopulateBrochures.php');
require_once($APPBASE.'functions/DedupEvent.php');
require_once($APPBASE.'functions/TransformUtils.php');

// Script class that will hold all sorts of things and be injected into functions.
$scr = new StdClass;

$scr->VERSION = "2.2";

// Super big script timeout.
ini_set('max_execution_time', 0);

// Set timezone.
date_default_timezone_set("America/Detroit");


// Logging
$scr->LOG = new XperLogger('Log',"Transform",true);
$scr->LOG->AddDailyFileAppender('Daily File',$APPBASE.'logs','Transform','INFO','FATAL');
//$scr->log->AddEmailEventAppender("Event Emailer", "qa@xperience-det.com,malton@xperience-det.com", "WARN", "FATAL");
//$scr->log->AddEmailAppender("Batch Emailer", false, "malton@xperience-det.com", "TRACE", "FATAL");
$scr->LOG->AddEchoAppender("Echo", false, true, 'TRACE', 'FATAL');
$LOG = $scr->LOG;

// Task semaphore.
$scr->SemaphoreId = "Transform";

// See if we're in debug bode.
$DEBUG = XperCheckDebugMode();


////////////////////////////////////////////////////////////
// XperDb stuff
////////////////////////////////////////////////////////////

// Make this LOCALHOST or DEV or PROD
//$scr->DBMODE = 'LOCALHOST';
//$scr->DBMODE = 'DEV';
$scr->DBMODE = 'PROD';

if ($scr->DBMODE == 'LOCALHOST')
{
    $scr->DBCFG = $DBCFGLOCALHOST;
    //$scr->DBCFG = new XperDbConfig(
    //    "localhost",
    //    "root",
    //    "",
    //    null,
    //    "xperdev_data_transformations");
}
elseif ($scr->DBMODE == 'DEV')
{
    $scr->DBCFG = $DBCFGDEV;
    //$scr->DBCFG = new XperDbConfig(
    //    "xperience-us.com",
    //    "xperdev",
    //    "wkdp5du133b4y05l",
    //    Array('xperdev_data_transformations' => 'dev_xperdev_data_transformations'),
    //    "xperdev_data_transformations"
    //    );
}
elseif ($scr->DBMODE == 'PROD')
{
    $scr->DBCFG = $DBCFGPRODUCTION;
    //$scr->DBCFG = new XperDbConfig("xperience-us.com", "xperdev", "wkdp5du133b4y05l", Array(), "xperdev_data_transformations");
}
////////////////////////////////////////////////////////////
// End of XperDb stuff
////////////////////////////////////////////////////////////

?>