<?php

$APPDIR = substr(__DIR__,0,strlen(__DIR__)) . '/';

$CMDLINE = (php_sapi_name() == 'cli');
$CRON = (php_sapi_name() == 'cgi-fcgi');
$WEB = (!$CMDLINE && !$CRON);
$BR = "<br />";
$CRLF = "\n";
$CLITAB = "\t";
$HTMLTAB = "&nbsp;&nbsp;&nbsp;&nbsp;";
$EOL = ($WEB ? $BR : $CRLF);
$TAB = ($WEB ? $HTMLTAB : $CLITAB);


// A bunch of static functions related to the opeting environment of your app.
function IsWeb()
{
    return !IsConsole();
}


function IsConsole()
{
    //return (php_sapi_name() === 'cli');
    return (($_SERVER['REMOTE_ADDR'] == "") && ((php_sapi_name() == 'cli') || (php_sapi_name() == 'cgi-fcgi')));
}


// This is a envirionment-sentitive end-of-line (i.e, '<br/>' if this is a web app).
function EOL()
{
    if (IsWeb())
        return '<br />';
    else
        return "\n";
}

// This is a envirionment-sentitive tab (i.e, '&nbsp;&nbsp;&nbsp;&nbsp;' if this is a web app).
function TAB()
{
    if (IsWeb())
        return '&nbsp;&nbsp;&nbsp;&nbsp;';
    else
        return "\t";
}

function XperCheckDebugMode()
{
    global $argv;

    if (isset($argv))
        foreach ($argv as $arg)
            if (strtolower($arg) == "debug=true")
                return true;

    if (isset($_GET) && isset($_GET["debug"]) && strtolower($_GET["debug"]) == "true")
        return true;

    return false;
}

function XperCheckGoTrue()
{
    global $argv;
    global $_GET;

    if (isset($argv))
        foreach ($argv as $arg)
            if (strtolower($arg) == "go=true")
                return true;

    if (isset($_GET) && isset($_GET["go"]) && strtolower($_GET["go"]) == "true")
        return true;

    return false;
}

?>



