<?php
require_once("log4php/Logger.php");

class XperLoggerLayoutHtmlCompatible extends LoggerLayoutPattern
{
    private $usehtml = true;


    public function __construct($html=true)
    {
        parent::__construct();
        $this->usehtml = $html;
    }


    // $event is a LoggerLoggingEvent
    function format(LoggerLoggingEvent $event)
    {
        $msg = parent::format($event);

        if ($this->usehtml)
        {
            $msg = str_replace("\n", "<br />".PHP_EOL, $msg);
            $msg = str_replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;", $msg);
        }
        else
        {
            // Replace \n with the appropriate line ending for this system.
            $msg = str_replace("\n", PHP_EOL, $msg);
        }

        return $msg;
    }
}


class XperLogger extends Logger
{
    private $applicationname = "";
    private $autoflush = false;

    public function __construct($loggername,$applicationname,$autoflush=false)
    {
        parent::__construct($loggername);
        $this->applicationname = $applicationname;
        $this->autoflush = $autoflush;
        $this->setLevel(LoggerLevel::getLevelTrace());
    }


    // Override. We always flush after Trace.
	public function trace($message, $throwable = null) {
		parent::trace($message, $throwable);
        if ($this->autoflush) flush();
	}


    public function AddDailyFileAppender($appendername,$path,$prefix,$minlevel,$maxlevel)
    {
        try
        {
            foreach ($this->getAllAppenders() as $app)
                if ($app->getName() == $appendername)
                    throw new Exception("There is already an appender with the name $appendername.");

            $pathprefix = str_replace("\\","/",$path);
            $pathprefix .= (substr($pathprefix,strlen($pathprefix)-1,1)=="/" ? "" : "/");
            $pathprefix .= $prefix;

            // Appender
            $app = new LoggerAppenderDailyFile($appendername);
            $app->setFile($pathprefix."-%s.log");
            $app->setDatePattern("Y-m-d");
            $app->setAppend(true);
            $app->setThreshold('all');

            // Layout
            $lay = new XperLoggerLayoutHtmlCompatible(false);
            //$lay = new LoggerLayoutPattern();
            $lay->setConversionPattern("%date{Y-m-d H:i:s} [%level] %message (%file : %line)\n");
            $lay->activateOptions();

            // Range filter
            $flt = new LoggerFilterLevelRange();
            $flt->setLevelMin($minlevel);
            $flt->setLevelMax($maxlevel);
            $flt->activateOptions();

            // Add layout and range filter to the appender
            $app->setLayout($lay);
            $app->addFilter($flt);
            $app->activateOptions();

            // Add appender to the root logger.
            $this->addAppender($app);
        }
        catch (Exception $ex)
        {
            throw new Exception("XperLogger.php / AddDailyFileAppender(). Error: ".$ex->getMessage());
        }
    }


    public function AddEmailEventAppender($appendername, $to, $minlevel, $maxlevel)
    {
        try
        {
            foreach ($this->getAllAppenders() as $app)
                if ($app->getName() == $appendername)
                    throw new Exception("There is already an appender with the name $appendername.");

            $from = "XperLog <xperlog@xperience-det.com>";
            $subject = "LOG EVENT - ".$this->applicationname;

            // Appender
            $app = new LoggerAppenderMailEvent("EmailEventAppender");
            $app->setTo($to);
            $app->setFrom($from);
            $app->setSubject($subject);
            $app->setThreshold('all');

            // Layout
            $lay = new XperLoggerLayoutHtmlCompatible(false);
            //$lay = new LoggerLayoutPattern();
            $lay->setConversionPattern("Log entry from XperLog for ".$this->applicationname."\n \n-Date: %date{Y-m-d H:i:s} \n-Level: %level\n-Message: %message\n-File %file\n-Class %class\n-Method %method\n-Line %line\n\n");
            $lay->activateOptions();

            // Range filter
            $flt = new LoggerFilterLevelRange();
            $flt->setLevelMin($minlevel);
            $flt->setLevelMax($maxlevel);
            $flt->activateOptions();

            // Add layout and range filter to the appender
            $app->setLayout($lay);
            $app->addFilter($flt);
            $app->activateOptions();

            // Add appender to the root logger
            $this->addAppender($app);
        }
        catch (Exception $ex)
        {
            throw new Exception("XperLogger.php / AddDailyFileAppender(). Error: ".$ex->getMessage());
        }
    }


    public function AddEmailAppender($appendername, $includedate, $to, $minlevel, $maxlevel)
    {
        try
        {
            foreach ($this->getAllAppenders() as $app)
                if ($app->getName() == $appendername)
                    throw new Exception("There is already an appender with the name $appendername.");

            $pattern = ($includedate ? "%date{Y-m-d H:i:s} - " : "");
            $pattern .= "%message \n";

            $from = "XperLog <xperlog@xperience-det.com>";
            $subject = "Log batch - ".$this->applicationname;

            // Appender
            $app = new LoggerAppenderMail("EmailAppender");
            $app->setTo($to);
            $app->setFrom($from);
            $app->setSubject($subject);
            $app->setThreshold('all');

            // Layout
            $lay = new XperLoggerLayoutHtmlCompatible(false);
            //$lay = new LoggerLayoutPattern();
            $lay->setConversionPattern($pattern);
            $lay->activateOptions();

            // Range filter
            $flt = new LoggerFilterLevelRange();
            $flt->setLevelMin($minlevel);
            $flt->setLevelMax($maxlevel);
            $flt->activateOptions();

            // Add layout and range filter to the appender
            $app->setLayout($lay);
            $app->addFilter($flt);
            $app->activateOptions();

            // Add appender to the root logger
            $this->addAppender($app);
        }
        catch (Exception $ex)
        {
            throw new Exception("XperLogger.php / AddDailyFileAppender(). Error: ".$ex->getMessage());
        }
    }


    public function AddEchoAppender($appendername, $includedate, $includebreaks, $minlevel, $maxlevel)
    {
        try
        {
            foreach ($this->getAllAppenders() as $app)
                if ($app->getName() == $appendername)
                    throw new Exception("There is already an appender with the name $appendername.");

            ////$cmdline = ((php_sapi_name() == 'cli') || (php_sapi_name() == 'cgi-fcgi'));
            $cmdline = ((!isset($_SERVER['REMOTE_ADDR']) || ($_SERVER['REMOTE_ADDR'] == "")) && ((php_sapi_name() == 'cli') || (php_sapi_name() == 'cgi-fcgi')));
            //$br = ($cmdline ? "\n" : "<br />");
            $pattern = ($includedate ? "%date{Y-m-d H:i:s} - " : "");
            $pattern .= "%m ";
            $pattern .= ($includebreaks ? "\n" : "");

            // Appender
            $app = new LoggerAppenderEcho($appendername);
            //$app->setHtmlLineBreaks = ($cmdline ? false : true);
            $app->setThreshold('all');

            // Layout
            $lay = new XperLoggerLayoutHtmlCompatible(!$cmdline);
            //$lay = new LoggerLayoutPattern();
            $lay->setConversionPattern($pattern);
            $lay->activateOptions();

            // Range filter
            $flt = new LoggerFilterLevelRange();
            $flt->setLevelMin($minlevel);
            $flt->setLevelMax($maxlevel);
            $flt->activateOptions();

            // Add layout and range filter to the appender
            $app->setLayout($lay);
            $app->addFilter($flt);
            $app->activateOptions();

            // Add appender to the root logger
            $this->addAppender($app);
        }
        catch (Exception $ex)
        {
            throw new Exception("XperLogger.php / AddDailyFileAppender(). Error: ".$ex->getMessage());
        }
    }


    public function RemoveEmailAppender($appendername)
    {
        try
        {
            if ($this->getAppender($appendername))
                $this->removeAppender($app);
        }
        catch (Exception $ex)
        {
            throw new Exception("XperLogger.php / RemoveEmailAppender(). Error: ".$ex->getMessage());
        }
    }

}

