<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// Get the base folder of this app.

// Do not use this. 
// Instead, you must make a project-specific class that inherits XperDbService.
class XperDbContext
{
    /// db config for local machine database
    private $DBCFG;
    private $dbuser = "";
    private $dbhostname = "";
    private $dbpass = "";
    private $dbdefault = "Support";
    private $lasterror = null;

    
    function __construct($DBCFG)
    {
        global $LOG;

        if (!$DBCFG)
            throw new Exception('XperDbContext constructor was given a null database configuration.');

        $this->dbcfg = $DBCFG;

        try
        {
            $this->db = new PDO(
                    'mysql:host='.$DBCFG->dbhost.';dbname='.$DBCFG->defaultdb.';charset=utf8',
                    $DBCFG->dbuser,
                    $DBCFG->dbpass);
           // $this->db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        }
        catch (PDOException $ex)
        {
            $LOG->Error('XperDbContext.php __contsruct(). Unable to connect to default database. Error: ' . $ex->getMessage());
            die('XperDbContext.php __contsruct(). Unable to connect to default database. Error: ' . $ex->getMessage());
        }
    }


    function __destruct()
    {
        $this->close();
	}


    function Config()
    {
        return $this->dbcfg;
    }


    function Close()
    {
        $lasterror = null;

        if ($this->db != null)
        {
		    $this->db = null;
        }
    }


    function IsError()
    {
        return ($this->lasterror != null);
    }


    function Error()
    {
        return ($this->IsError() ? $this->lasterror[2] : '');
    }


    function Quote($string)
    {
        $lasterror = null;
        return $this->db->quote($string);
    }


    // E.g.: $vals = array(":eventid" => $val)
    function Execute($string,$vals,&$rows)
    {
        global $LOG;

        $lasterror = null;
        if (!($prep = $this->db->prepare($string)))
        {
            $this->lasterror = $prep->errorInfo();
            //$LOG->Error('XperDbContext.php Execute(). Error from prepare(): ' . $this->Error());
            return false;
        }

        $this->lasterror = null;
        if (!($prep->execute($vals))) 
        {
            $this->lasterror = $prep->errorInfo();
            //$LOG->Error('XperDbContext.php Execute(). Error from execute(): ' . $this->Error());
            return false;
        }
        
        try
        {
            $rows = $prep->fetchAll(PDO::FETCH_ASSOC);
        }
        catch (Exception $e)
        {
            //$LOG->Error('XperDbContext.php Execute() catch. Error: ' . $e->getMessage());
            return false;
        }

        return true;
    }


    // E.g.: $vals = array(":eventid" => $val)
    function ExecuteNonQuery($string,$vals,&$newid)
    {
        

        global $LOG;

        $this->lasterror = null;
        if (!($prep = $this->db->prepare($string)))
        {
            $this->lasterror = $prep->errorInfo();
            $LOG->Error('XperDbContext.php ExecuteNonQuery(). Error from prepare(): ' . $this->Error());
            return false;
        }

        $this->lasterror = null;
        if (!($prep->execute($vals))) {
           
            
            $this->lasterror = $prep->errorInfo();
            
            $LOG->Error('XperDbContext.php ExecuteNonQuery(). Error from execute(): ' . $this->Error());
            return false;
           
          
            die("mazdie2");
        }

        $newid = $this->db->lastInsertID();

        return true;
    }


    function Query($string,&$rows)
    {
        $this->lasterror = null;
        $rows = $this->db->query($string);

        return true;
    }


    // function MultiQuery($string, $rows)
    // {   
    //     $lasterror = null;

    //     $res = [];
    //     try {
    //         $stmnt = $this->db->query($string);

    //         if (!$stmnt)
    //         {
    //             $rows [] = "Multi query failed: (" . $this->db->errorCode() . ") ";
    //             return false;
    //         }
    //         do
    //         {
    //             $rows[] = $stmnt->fetchAll(PDO::FETCH_ASSOC);

    //         } while($stmnt->nextRowset());
    //         return true;
    //     }
    //     catch (PDOException $ex)
    //     {
    //         $rows [] = "Multi query failed: (" . $this->db->errno . ") " . $this->db->error;
    //         return false;
    //     }
    // }


    function LastInsertID()
    {
        return $this->db->lastInsertID();
    }


    function BeginTransaction()
    {
        return $this->db->beginTransaction();
    }


    function CommitTransaction()
    {
        return $this->db->commit();
    }


    function RollBackTransaction()
    {
        return $this->db->rollBack();
    }

}

?>