<?php
require_once($APPBASE."config/TransformConfig.php");


function IsTestReg($zip, $email)
{
    if ($zip == '12345')
        return true;

    if (strpos($email,'@test.com'))
        return true;

    return false;
}


function Deblob($data)
{
	$return_data = array();

    $pairs = explode("{{}}",$data);

    foreach ($pairs as $one_pair)
    {
        $delimit = strpos($one_pair,"(())");
        $name = substr($one_pair,0,$delimit);
        $val = substr($one_pair,$delimit+4);
        $return_data[$name] = $val;
	}

    unset($return_data[0]);

    return $return_data;
}


function ConvertTracker($tracker)
{
    $tracker = trim($tracker);

    // convert hex tracker into decimal
    //
    // case 1: already decimal!
    if ((is_numeric($tracker)) && (strlen($tracker)>17))
    {
        return $tracker;
    }

    // case 2: 16 digits of hex ending in E0
    if ((ctype_xdigit($tracker)) && (strlen($tracker)==16) && (strtoupper(substr($tracker, -2)) == "E0"))
    {
        // first reverse bytes
        $new_tracker = "";
        while (strlen($tracker) > 0)
        {
            $new_tracker .= strtoupper(substr($tracker, -2));
            $tracker = substr($tracker, 0, strlen($tracker)-2);
        }
        // now convert to decimal
        $tracker = LargeHexdec($new_tracker);
    }
    // case 3: short hex from puck
    elseif (ctype_xdigit($tracker) && (strlen($tracker) < 15))
    {
        if (strlen($tracker) %2 == 1)
        {
            $tracker="0".$tracker;
        }
        $tracker = LargeHexdec("E0".$tracker);
    }
}


function LargeHexdec($hex) {
	$final = "0";
	$place = "0";

    while (strlen($hex)>0)
    {
		$next = substr($hex,-1);
		$final = bcadd($final,bcmul("".hexdec($next)."",bcpow("16",$place)));
		$hex = substr($hex,0,strlen($hex)-1);
		$place = bcadd($place,'1');
	}

    return $final;
}


function IsAddressValid($scr, $addr1, $addr2, $city, $state, $zip, $country)
{
    if ((is_null($addr1) && is_null($addr2)) || is_null($city) || is_null($state) || is_null($zip))
        return false;

    if ((trim($addr1) == '' && trim($addr2) == '') || trim($city) == '' || trim($state) == '' || trim($zip) == '')
        return false;

    if (strlen($state) > 2 && $country == 'USA')
        return false;

    if (strlen($zip) > 5 && $country == 'USA')
        return false;

    $scr->db = new TransformDbService($scr->DBCFG);

    $scr->db->ZipCodeLookup($zip, $rec);
    if (count($rec) == 0 || strtolower($rec["StateProvinceID"]) != strtolower($state))
        return false;

   return true;
}


function EndsWith($haystack, $needle)
{
    $length = strlen($needle);
    if ($length == 0) {
        return true;
    }

    return (substr($haystack, -$length) === $needle);
}
?>
