<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// populates/transforms a single event
require_once($APPBASE."config/TransformConfig.php");


function PopulateEvent($scr, $eventid, &$processed)
{
    global $FLAGBITS;


    $voiyearfix = array(
        '2018 FLEX' => '2019 FLEX',
        '2018 ESCAPE' => '2019 ESCAPE',
        '2018 MUSTANG' => '2019 MUSTANG',
        '2018 TAURUS' => '2019 TAURUS',
        '2018 EXPEDITION' => '2019 EXPEDITION',
        '2018 SUPER DUTY' => '2019 SUPER DUTY',
        '2018 FORD GT' => '2019 FORD GT',
        '2018 EDGE' => '2019 EDGE',
        '2018 EXPLORER' => '2019 EXPLORER',
        '2018 RAPTOR' => '2019 RAPTOR',
        '2018 FUSION' => '2019 FUSION',
        '2018 F-150' => '2019 F-150',
        '2018 TRANSIT' => '2019 TRANSIT',
        '2018 FIESTA' => '2019 FIESTA',
        '2018 ECOSPORT' => '2019 ECOSPORT'
    );


    $scr->LOG->Trace('PopulateEvent(). Event: '.$eventid);

    // Get info about the event
    if (!($scr->db->GetEvent($scr, $eventid, $event)))
    {
        $scr->LOG->Error("Error getting event ($eventid): ".$scr->db->Error());
        return false;
    }

    $tourdb = $event['Event_DB'];
    $tourtable = $event['Table_Name'];

    // Go get the count of how many records we're going to process.
    if (!($scr->db->GetTourTableRegsCount($scr, $eventid, $tourdb, $tourtable, $regstodo)))
    {
        
       
        $scr->LOG->Error("Error from GetTourTableRegs($eventid, $tourdb, $tourtable, ref). ".$scr->db->Error());
        return false;
    }
    print_r("dumpVar----");
 var_dump($regstodo);
 print_r("-----dumpVar");
    $scr->LOG->Trace("Records to be transformed: ".$regstodo);

    $regcount = 0;
    $transformcount = 0;
    $extracount = 0;

    $done = false;

    while (!$done and $regcount < $regstodo)
    {

        
        // Go get records from the tour table that have not yet been transformed.
        if (!($scr->db->GetTourTableRegs($scr, $eventid, $tourdb, $tourtable, $regs)))
        {
            
            $scr->LOG->Error("Error getting tour table regs ($eventid, $tourdb, $tourtable). ".$scr->db->Error());
            $done = true;
            continue;
        }

        if (count($regs) == 0)
        {
            $done = true;
            continue;
        }

        foreach ($regs as $reg)
        {

           
            $regcount++;

            $id = $reg['id'];

            //$scr->LOG->Trace('id = '.$id);

            $insertvals = array();
            $extravals = array();

            $insertvals['Language'] = 'EN';      // Priming
            $insertvals['Country'] = 'USA';      // Priming

            $blob = Deblob($reg['data']);
            //$scr->LOG->Debug('$blob = '.var_export($blob,true));
            $pullid = $reg['pull_id'];

            $insertvals['event_id'] = $eventid;
            $insertvals['table_name'] = $tourtable;
            $insertvals['table_id'] = $id;
            $insertvals['pull_id'] = $pullid;
            $insertvals['tracker'] = ConvertTracker($reg['tracker']);
            $insertvals['time_in'] = $reg['time_in'];
            $insertvals['duplicate'] = 0;
            
            // Figure the subgroup.
            if (strtolower($pullid) == '_pre_reg_')
                $insertvals['event_subgroup'] = '2';
            elseif (strtolower($pullid) == '_sweeps_' || strtolower($pullid) == 'sweeps' || strtolower($pullid) == '_website_' || strtolower($pullid) == 'website')
                $insertvals['event_subgroup'] = '3';
            elseif (strtolower($pullid) == '_mobile_')
                $insertvals['event_subgroup'] = '7';
                elseif (strtolower($pullid) == '_count_challenge_')
                $insertvals['event_subgroup'] = '4';
                elseif (strtolower($pullid) == '_paper_')
                $insertvals['event_subgroup'] = '6';
            elseif (isset($blob['Activity']) && strpos(strtolower($blob['Activity']),'count challenge') !== false)
                $insertvals['event_subgroup'] = '4';
            elseif (isset($blob['Activity']) && strpos(strtolower($blob['Activity']),'trivia challenge') !== false)
                $insertvals['event_subgroup'] = '5';
            elseif (isset($blob['Activity']))
                $insertvals['event_subgroup'] = '6';
            else
                $insertvals['event_subgroup'] = '1';
             
            // Go through each value in the blob and transform them, according to field values.
            foreach ($blob as $key=>$value)
            {

                // These can be ignored.
                if (strstr($key,"ParseType")) continue; //
                if (strstr($key,"EventCode")) continue; // is this even used?
                if (strstr($key,"Barcode")) continue; // ??
                if (strstr($key,"EventDate")) continue; // reflected in time_in
                if (strstr($key,"EndLine")) continue;

                if ($key == "Province")
                {
                    $insertvals['Country'] = 'Canada';
                    continue;
                }

                // TODO: more specific call out of language
                if ($key == "First_Name")
                {
                    if (ord(substr($value,0,1)) > 200)
                    {
                        $insertvals['Language']="'Arabic'";
                    }
                }

                // paper reg does strange things with phone numbers, so....
                if ($key == "Cell")
                {
                    $insertvals['Cell'] = (isset($blob['PrimaryPhone']) ? $blob['PrimaryPhone'] : (isset($blob['Phone']) ? $blob['Phone'] : null));
                    continue;
                }
                if ($key == "Home")
                {
                    $insertvals['Phone'] = (isset($blob['PrimaryPhone']) ? $blob['PrimaryPhone'] : (isset($blob['Phone']) ? $blob['Phone'] : null));
                    continue;
                }
                if ($key == "Work")
                {
                    $insertvals['Phone'] = (isset($blob['PrimaryPhone']) ? $blob['PrimaryPhone'] : (isset($blob['Phone']) ? $blob['Phone'] : null));
                    continue;
                }
   
                // See if it's in field_mapping
                if (array_key_exists($key,$scr->fields))
                {
                    $fld = $scr->fields[$key];
                    $fldtype = $fld['FieldType'];
                    $fldnew = $fld['TransformedField'];
                    $fldlen = $fld['FieldLength'];

                    if ($fldtype == "")
                    {
                        if (trim($value) == "Spanish")
                        {
                            $value = 'ES';
                        }
                        if (trim($value) == "English")
                        {
                            $value = 'EN';
                        }

                        if ($fldlen)
                            $insertvals[$fldnew] = substr(addslashes(trim($value)),0,$fldlen);
                        else
                            $insertvals[$fldnew] = addslashes(trim($value));
                    }
                    else if ($fldtype == "yesno")
                    {
                        if (strtolower(substr($value,0,1)) == 'y')
                        {
                            $insertvals[$fldnew] = "Yes";
                        //  for email optin so have logic to translate -1- to -yes-
                        }
                        elseif (strtolower(substr($value,0,1)) == '1')
                        {
                            $insertvals[$fldnew] = "Yes";
                        }
                        else
                        {
                            $insertvals[$fldnew] = "No";
                        }
                    }
                    else if ($fldtype == "lang-e")
                    {
                        if (strtolower(substr($value,0,2)) == 'en')
                        {
                            $insertvals[$fldnew] = "EN";
                        }
                    }
                    else if ($fldtype == "lang-s")
                    {
                        if (strtolower(substr($value,0,2) )== 'es')
                        {
                            $insertvals[$fldnew] = "ES";
                        }
                    }
                }
                else
                {
                    $extravals[$key] = addslashes(trim($value));
                }

                // US is not what the country should be; it's USA
                if ($insertvals['Country'] == "US")
                    $insertvals['Country'] = "USA";
            }


            // See if it's a VOI needing attention during The Great VOI Data Fix Of March 2019.
            // have to check this last because we might need language.
            if (isset($insertvals["vehicle_of_interest"]) && (trim($insertvals["vehicle_of_interest"]) != ""))
            {
                $newval = "";
                $language = $insertvals["Language"];
                $vois = explode('||',$insertvals["vehicle_of_interest"]);

                foreach ($vois as $voi)
                {
                    $newvoi = $voi;

                    // First, do the year thing.
                    if (array_key_exists($newvoi,$voiyearfix))
                    {
                        $newvoi = $voiyearfix[$newvoi];
                    }

                    if (!EndsWith($newvoi," EN") && !EndsWith($newvoi," ES"))
                    {
                        $newvoi .= " ".$language;
                    }

                    $newval .= ($newval=="" ? "" : "||").$newvoi;
                }

                $insertvals["vehicle_of_interest"] = $newval;
            }


            // Look for test records
            if (IsTestReg((isset($insertvals['ZipCode'])?$insertvals['ZipCode']:''), (isset($insertvals['Email'])?$insertvals['Email']:'')))
            {
                $insertvals['flags'] = (isset($insertvals['flags']) ? $insertvals['flags'] : 0) | $FLAGBITS["IGNORE"];
            }
            else
            {
                $insertvals['flags'] = (isset($insertvals['flags']) ? $insertvals['flags'] : 0) & $FLAGBITS["IGNORE"];
            }

            // Insert into 2015_registration_data.
            //$scr->LOG->Trace('$insertvals = '.var_export($insertvals, true));
            if (!($scr->db->InsertReg($scr, $insertvals, $newid)))
            {
                die("maz2");
                $scr->LOG->Error("Error inserting reg ($eventid, $id). ".$scr->db->Error());
                $done = true;
                continue;
            }
            $transformcount++;

            // Insert into extraneous data.
            if (count($extravals) > 0)
            {
                $vallist = '';
                foreach ($extravals as $key=>$val)
                {
                    $vallist .= ($vallist==''?'':',').$key.' => '.$val;
                }

                //$scr->LOG->Trace('$vallist = '.var_export($vallist, true));
                if (!($scr->db->InsertOrUpdateExtraneous($scr, $newid, $vallist, $newid)))
                {
                    $scr->LOG->Error("Error inserting into extraneous ($eventid, $id, $vallist). ".$scr->db->Error());
                    $done = true;
                    continue;
                }
                $extracount++;
            }
        }

        if ($regcount % 1000 == 0)
        {
            $scr->LOG->Trace($regcount.' of '.$regstodo);
        }
    }

    $scr->LOG->Trace('Populate finished. Examined '.$regcount.' regs, '.$transformcount.' transformed, '.$extracount.' extraneous');
    $scr->LOG->Debug('Exiting PopulateEvent()');

    $processed = $transformcount;

    return true;
}
?>
