<?php
// populates/transforms a single event
require_once($APPBASE."config/TransformConfig.php");


function PopulateBrochures($scr, $eventid, &$processed)
{
    $scr->LOG->Trace('PopulateBrochures(). Event: '.$eventid);

    // Go get the count of how many recors we're going to process.
    if (!($scr->db->GetBrochureRegsCount($scr, $eventid, $regstodo)))
    {
        $scr->LOG->Error("Error from GetBrochureRegsCount ($eventid, ref). ".$scr->db->Error());
        return false;
    }

    $scr->LOG->Trace("Brochure records to be examined: ".$regstodo);
    if ($regstodo == 0)
    {
        $processed = 0;
        return true;
    }

    $regcount = 0;
    $brochurecount = 0;

    $done = false;
    $offset = 0;

    while (!$done)
    {
        // Go get records from the tour table that have not yet been transformed.
        if (!($scr->db->GetBrochureRegs($scr, $eventid, $offset, $regs)))
        {
            $scr->LOG->Error("Error from GetBrochureRegs($eventid, $offset). ".$scr->db->Error());
            $done = true;
            continue;
        }

        if (count($regs) == 0)
        {
            $done = true;
            continue;
        }

        foreach ($regs as $reg)
        {
            $regcount++;

            $id =  $reg['id'];
            $voidata = $reg['vehicle_of_interest'];

            if (stristr($voidata,"||"))
            {
                $voilist = explode('||', $voidata);
            }
            else
            {
                $voilist = explode(',', $voidata);
            }

            if (count($voilist) > 0)
            {
                foreach ($voilist as $voi)
                {
                    if (trim($voi) == "" || trim($voi) == "vehicle_of_interest" || trim($voi) == "VOI")
                    {
                        continue;
                    }

                    $voi = str_replace(".png", "", $voi);

                    // Insert brochure data.
                    if (!($scr->db->InsertBrochure($scr, $id, $voi, $ignore)))
                    {
                        $scr->LOG->Error("Error from InsertBrochure ($eventid, $voi). ".$scr->db->Error());
                        $done = true;
                        continue;
                    }
                    $brochurecount++;
                }
            }
        }

        if ($regcount % 1000 == 0)
        {
            $scr->LOG->Trace($regcount.' of '.$regstodo); //flush();
        }
    }

    $scr->LOG->Trace('Bruchuring finished. Examined '.$regcount.' regs, '.$brochurecount.' total brochures.');
    $scr->LOG->Debug('Exiting PopulateBrochures()');

    $processed = $brochurecount;

    return true;
}
?>
