<?php
// dedupes a single event
require_once($APPBASE."config/TransformConfig.php");


function DedupEvent($scr,$eventid, &$processed)
{
    $scr->LOG->Trace('DedupEvent(). Event: '.$eventid);

    $ctxt = new XperDbContext($scr->DBCFG);
    $db = new TransformDbService($ctxt);

    if (!($db->GetKeysForDedup($scr, $eventid, $keys)))
    {
        $scr->LOG->Error("Error from GetKeysForDedup() (eventid=$eventid). ".$db->Error());
        return false;
    }

    if (count($keys) == 0)
    {
        // Nothing to do.
        return true;
    }

    $keycount = 0;
    $duplicatecount = 0;

    foreach ($keys as $key)
    {
        $dupkey = $key['DupKey'];
        $maxdup = $key["MaxDup"];

        $scr->LOG->Trace("DupKey: $dupkey, MaxDup: ".($maxdup == null ? "null" : $maxdup));

        if (!($db->GetRegsForDedup($scr, $eventid, $dupkey, $regs)))
        {
            $scr->LOG->Error("Error from GetRegsForDedup() (eventid=$eventid). ".$db->Error());
            return false;
        }

        $dupseq = ($maxdup==null?0:$maxdup+1);

        foreach ($regs as $reg)
        {
            $id = $reg['id'];

            $scr->LOG->Trace("\tid: $id, dupseq: $dupseq");

            if (!($db->UpdateRegDuplicate($scr, $id, $dupseq)))
            {
                $scr->LOG->Error("Error from UpdateRegDuplicate() (id=$id, dupseq=$dupseq). ".$db->Error());
                return false;
            }

            $duplicatecount++;
            $dupseq++;
        }

        $keycount++;
    }



    //    if ($dupkey != $prevdupkey)
    //    {
    //        $dupseq = 0;
    //        $prevdupkey = $dupkey;
    //        $originalscount++;
    //    }
    //    else
    //    {
    //        $dupseq++;
    //        $duplicatecount++;
    //    }

    //    // $scr->LOG->Trace((is_null($reg['duplicate'])?"null":(string)$reg['duplicate']).' - '.$dupseq.' - '.$timein.' - '.$dupkey);
    //    // flush();

    //    // See if it needs to be changed.
    //    //if (is_null($reg['duplicate'])) // || $reg['duplicate'] != $dupseq)
    //    if (strtotime($timein) >= strtotime('2018-07-20 12:00:00') && (is_null($reg['duplicate']) ||  ($reg['duplicate'] != $dupseq)))
    //    {
    //        if (!($db->UpdateRegDuplicate($scr, $id, $dupseq)))
    //        {
    //            $scr->LOG->Error("Error updating reg duplicate value ($id, $dupseq). ".$db->Error());
    //            return false;
    //        }

    //        $updatedcount++;

    //        //echo '+';
    //    }
    //    else
    //    {
    //    }

    //    if ($updatedcount > 0 && $updatedcount % 100 == 0)
    //    {
    //        //$scr->LOG->Trace('');
    //    }
    //}

    //if ($updatedcount > 0)
    //{
    //    //$scr->LOG->Trace('');
    //}

    //if ($regcount % 100 == 0)
    //{
    //    $scr->LOG->Trace($regcount.' of '.$regstodo.' ('.$updatedcount.')');
    //}

    $processed = $duplicatecount;

    $scr->LOG->Trace("Dedup finished. Examined $keycount dupkeys, updated $duplicatecount duplicates.");
    $scr->LOG->Debug('Exiting DedupEvent()');

    return true;
}
?>

