<?php
// This function isw a test-and-set for a semphore file in the current directory.
// If it already exists, it returns false. If it does not elready exist, it creates
// it and returns true.
//
// The argument $semaphoreid must be a string that will be valid in a filename.
function XperSetSemaphore($semaphoreid)
{
    $filename = "_semaphore_".$semaphoreid."_";

    if (file_exists($filename))
        return false;

    // Create the semaphore filename.
    if (!($fil = fopen($filename, "w")))
        return false;

    // Write the current date/time into the file.
    $d = new DateTime();
    fwrite($fil,$d->format("m/d/Y H:i:s"));
    fclose($fil);

    return true;
}


// Clears a semaphore. Only returns false if it can't clear it.
//
// The argument $semaphoreid must be the same that was given to SetSemaphore().
function XperClearSemaphore($semaphoreid)
{
    $filename = "_semaphore_".$semaphoreid."_";

    if (file_exists($filename))
        unlink($filename);
    
    return true;
}


// Checks the date written into the semaphore file.
function XperGetSemaphoreDate($semaphoreid)
{
    $filename = "_semaphore_".$semaphoreid."_";

    if (!file_exists($filename))
        return null;
    
    // Get the last modification time of the file.
    if (!($fil = fopen($filename, "r")))
        return false;

    $lin = fgets($fil,19);
    $d = new DateTime($lin);

    return $d;
}

?>
