<?php

// Convert from UTC to the given time zone. 
// You can give this either string dates or object dates.
function FromUTC($dattim, $tz=null) 
{
    
    if ($dattim == null) return null;

    if (!is_object($dattim))
        if (trim($dattim) == '') 
            return null;
        else
            $dattim = new DateTime($dattim);

    if ($tz == null || trim($tz) == '') 
        $tz = "America/Detroit";
    
    return ConvertTZ($dattim,"UTC",$tz);
}


// Convert from the given time zone to UTC.
// You can give this either string dates or object dates.
function ToUTC($dattim, $tz=null) 
{
    if ($dattim == null) return null;

    if (!is_object($dattim))
        if (trim($dattim) == '') 
            return null;
        else
            $dattim = new DateTime($dattim);
    
    if ($tz == null || trim($tz) == '') 
        $tz = date_default_timezone_get();
    
    return ConvertTZ($dattim,$tz,"UTC");
}


function ConvertTZ($dattim, $FromTZ = null, $ToTZ = null)
{
    if (empty($FromTZ)) 
    {
        $timeZoneSource = date_default_timezone_get();
    }
    
    if (empty($ToTZ)) 
    {
        $timeZoneTarget = date_default_timezone_get();
    }

    if (is_object($dattim))
        $dtstring = $dattim->format("Y-m-d H:i:s");
    else
        $dtstring = $dattim;

    $dt = new DateTime($dtstring, new DateTimeZone($FromTZ));
    $dt->setTimezone(new DateTimeZone($ToTZ));

    return $dt->format("Y-m-d H:i:s");
}
