<?php
require_once('XperDbContext.php');
require_once('XperDbConfig.php');


class XperDbService
{
    // private $DBCFG = null;
    private $db = null;  // This must be a XperDbContext object.


    // Must pass this a XperDbContext object
    function __construct($dbctxt)
    {
        global $LOG;

        if (!$dbctxt)
            throw new Exception('XperDbService constructor was given a null database context.');

        $this->db = $dbctxt;

        // $this->dbcfg = $XperDbConfig;

        // $this->db = new XperDbContext($XperDbConfig->dbhost, $XperDbConfig->dbuser, $XperDbConfig->dbpass);

        // $LOG->Debug('XperDbService class created with these substitutions: '.str_replace("\n"," ",print_r($XperDbConfig->dbsubs, true)));
    }


    private function GroomSql($sql)
    {
        if ($this->db->Config()->dbsubs)
        {
            foreach ($this->db->Config()->dbsubs as $key => $val)
                $sql = str_replace($key.'.', $val.'.', $sql);
        }

        $sql = str_replace("\n",' ',str_replace("\r",' ',str_replace("\t",' ',$sql)));
        while (strpos($sql,'  '))
            $sql = str_replace('  ',' ',$sql);

        return $sql;
    }


    function Escape($str)
    {
        return $this->db->quote($str);
    }


    function Execute($string, $vals, &$rows)
    {
        return $this->db->Execute($this->GroomSql($string),$vals,$rows);
    }


    function ExecuteNonQuery($string,$vals,&$newid)
    {
        $retval = $this->db->ExecuteNonQuery($this->GroomSql($string),$vals,$newid);

        return $retval;
    }


    function IsError()
    {
        return $this->db->IsError();
    }


    function Error()
    {
        return $this->db->Error();
    }


    function BeginTransaction()
    {
        return $this->db->BeginTransaction();
    }


    function CommitTransaction()
    {
        return $this->db->CommitTransaction();
    }


    function RollBackTransaction()
    {
        return $this->db->RollBackTransaction();
    }


    function LogAppActivity($file, $module, $activity, $data)
    {
        //global $LOG;

        //$LOG->Debug('XperDbContext.php LogAppActivity().');

        try
        {
            $appid = 4;
            $host = $_SERVER['SERVER_NAME'];
            $clientip = $_SERVER['REMOTE_ADDR'];
            $browser = $_SERVER['HTTP_USER_AGENT'];

            $sql = "call Support.LogAppInfo(:appid, :host, null, :file, :module, :activity, :clientip, :browser, :data)";

            if ($this->ExecuteNonQuery($sql, Array('appid'=>$appid, 'host'=>$host, 'file'=>$file, 'module'=>$module, 'activity'=>$activity, 'clientip'=>$clientip, 'browser'=>$browser, 'data'=>$data),$newid))
            {
                //$LOG->Debug("XperDbContext.php LogAppActivity(). Query success");
                return true;
            }
            else
            {
                //$LOG->Error("XperDbContext.php LogAppActivity(). Error " . $this->Error());
                return false;
            }
        }
        catch (Exception $e)
        {
            //$LOG->Error("dbcontect.php LogAppActivity(). Exception: " . $e->getMessage());
        }

        return true;
    }
}

?>
