<?php

class EndpointAutomationSettings
{
    private $dbsvc;

    public $id;
    public $EndpointType;
    public $Production;
    public $Active;
    public $LiveMode;
    public $DBWriteEnabled;
    public $FileWriteEnabled;
    public $TransmitEnabled;
    public $EventStartEarliest;
    public $EventStartAge;
    public $EventEndLatest;
    public $EventEndAge;
    public $DataEarliest;
    public $DataAge;
    public $CustomSettings;
    public $LastExecution;
    public $SqlSuffix;


    function __construct($dbsvc,$EndpointType, $Production)
    {
        if (!$dbsvc)
            throw new Exception('XperDbContext constructor was given a null database configuration.');
        $this->dbsvc = $dbsvc;

        $this->EndpointType = $EndpointType;
        $this->Production = $Production;

        // Load the data.
        $sql = "
            select * from Support.EndpointSettings
                where
                Production = (:production = 1)
                and EndpointType = :endpointtype
            ";

        $params = Array('production' => ($this->Production?1:0), 'endpointtype' => $this->EndpointType);
        $retval = $this->dbsvc->Execute($sql, $params, $rows);

        if (!$retval)
            throw new Exception('Error returned from fetch of Endpoint Settings data.');

        if (count($rows) == 0)
            throw new Exception('Zero rows  returned from fetch of Endpoint Settings data.');

        $row = $rows[0];

        $this->id = $row['id'];
        $this->Active = ($row['Active'] == 1);
        $this->LiveMode = $row['LiveMode'];
        $this->DBWriteEnabled = $row['DBWriteEnabled'];
        $this->FileWriteEnabled = $row['FileWriteEnabled'];
        $this->TransmitEnabled = $row['TransmitEnabled'];
        $this->EventStartEarliest = ($row['EventStartEarliest']==null?null:new DateTime($row['EventStartEarliest']));
        $this->EventStartAge = $row['EventStartAge'];
        $this->EventEndLatest = ($row['EventEndLatest']==null?null:new DateTime($row['EventEndLatest']));
        $this->EventEndAge = $row['EventEndAge'];
        $this->DataEarliest = ($row['DataEarliest']==null?null:new DateTime($row['DataEarliest']));
        $this->DataAge = $row['DataAge'];
        $this->CustomSettings = $row['CustomSettings'];
        $this->LastExecution = ($row['LastExecution']==null?null:new DateTime($row['LastExecution']));
        $this->SqlSuffix = $row['SqlSuffix'];
        //$this->SqlSuffix = ($row['SqlSuffix']==null?null:$row['SqlSuffix']);

        return;
    }


    function SetExecutionTime($exectime=null)
    {
        if ($exectime == null)
            $exectime = getdate();

        $sql = "
            update Support.EndpointSettings
                set
                    LastExecution = now()
                where
                    Production = (:production = 1)
                    and EndpointType = :endpointtype
            ";
        $params = Array('production' => ($this->Production?'1':'0'), 'endpointtype' => $this->EndpointType);
        $retval = $this->dbsvc->ExecuteNonQuery($sql, $params, $ignore);

        if (!$retval)
            return false;

        return true;
    }
}


?>
