<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once("config/TransformConfig.php");


try
{
    // Identify yourself.
    $scr->LOG->Info("Transform.php");

    // Track execution time.
    $scr->scriptstart = new DateTime();

    $scr->LOG->Info("Version ".$scr->VERSION);
    $scr->LOG->Info("Executed at " . $scr->scriptstart->format('m/d/Y H:i:s'));
    $scr->LOG->Trace("- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - ");
    $scr->LOG->Trace("");

    if (!XperCheckGoTrue())
    {
        $scr->LOG->Error('Script must be executed with go=true parameter in the url or command line. Recommend checking EndpointSettings before executing.');
        die();
    }

    // Sleep for a random time. Part of the fix for multiple process problem from March 2019.
    $wait = rand(10000,3000000);
    $waitsecs = $wait / 1000000;
    $scr->LOG->Trace("Pausing for $waitsecs seconds.");
    usleep($wait);
    $scr->LOG->trace("");


    // Check and set a semaphore to show we are already executing.
  /*   if (!XperSetSemaphore($scr->SemaphoreId))
    {
        $d = XperGetSemaphoreDate($scr->SemaphoreId);
        $scr->LOG->Info("***** An instance of Transform was already running. It was launched at ".$d->format("m/d/Y H:i:s").". Exiting.");
        die();
    } */

    if ($scr->DBCFG->dbsubs)
        foreach ($scr->DBCFG->dbsubs as $key => $val)
            $scr->LOG->Trace("Database substitutions: $key => $val");

    // Database service.
    $scr->db = new TransformDbService(new XperDbContext($scr->DBCFG));


    // Get field mappings.
    if (!($scr->db->GetFieldMappings($scr, $mappings)))
    {
        $scr->LOG->Error('Error getting field mappings. '.$scr->db->Error());
        return false;
    }
    $scr->fields = array();
    foreach ($mappings as $mapping)
    {
        $scr->fields[$mapping['RegField']] = array(
            'TransformedField' => $mapping['TransformedField'],
            'FieldType' => $mapping['FieldType'],
            'FieldLength' => $mapping['FieldLength']
        );
    }


    // Transform and dedup leads from tour tables into 2015 table.
    $eventcount = 0;
    $brochurecount = 0;
    $dedupcount = 0;
    $transformcount = 0;


    if (!($scr->db->GetEventsForTransform($scr, $events)))
    {
        $scr->LOG->Error("Error getting events. ".$scr->db->Error());
        return false;
    }

    $scr->LOG->Info('Found '.count($events).' events.');

    $step1elapsed = 0;
    $step2elapsed = 0;
    $step3elapsed = 0;

    foreach ($events as $event)
    {
        $eventcount++;

        $eventtransformcount = 0;
        $eventbrochurecount = 0;
        $eventdedupcount = 0;

        $eventid = $event['Event_Id'];
        $eventname = $event['Event_Name'];
        $tourid = $event['Tour_Id'];
        $tourname = $event['Tour_Name'];

        $scr->LOG->Trace("");
        $scr->LOG->Info("Event ".$event['Event_Id'].", ".$event['Event_Name']);
        $scr->LOG->Info("Tour ".$event['Tour_Id'].", ".$event['Tour_Name']);
        $scr->LOG->Trace("Tour table: ".$event["Event_DB"].'.'.$event["Table_Name"]);

        $scr->LOG->Trace("Populating...");

        $step1start = microtime(true);
        $processed = 0;
        if (!PopulateEvent($scr,$eventid, $processed))
        {
            $scr->LOG->Error("PopulateEvent() failed ($eventid).");
            return false;
        }
        $eventtransformcount = $processed;
        $transformcount += $processed;
        $step1elapsed += microtime(true) - $step1start;

        if ($processed > 0)
        {
            $scr->LOG->Trace("Brochureing..."); //flush();
            $step2start = microtime(true);
            $processed = 0;
            if (!PopulateBrochures($scr,$eventid, $processed))
            {
                $scr->LOG->Error("PopulateBrochures() failed ($eventid).");
                return false;
            }
            $eventbrochurecount = $processed;
            $brochurecount += $processed;
            $step2end = new DateTime();
            $step2elapsed += microtime(true) - $step2start;
           
            $scr->LOG->Trace("Deduping..."); //flush();
            $step3start = microtime(true);
            $processed = 0;
            
            if (!DedupEvent($scr,$eventid, $processed))
            {
                $scr->LOG->Error("DedupEvent() failed ($eventid).");
                return false;
            }
            $eventdedupcount = $processed;
            $dedupcount += $processed;
            $step3elapsed += microtime(true) - $step3start;
        }

        $scr->LOG->Info("Transformed: $eventtransformcount. Brochures: $eventbrochurecount. Deduped: $eventdedupcount.");
    }
}
catch (Exception $ex)
{
    // Uh oh.
    $scr->log->Error("***** Exception caught in script main: ".$ex->getMessage()." *****");
}

$scr->scriptend = new DateTime();
$scr->scriptelapsed = $scr->scriptstart->diff($scr->scriptend);

$scr->LOG->Trace('');
$scr->LOG->Trace("- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - \t");
$scr->LOG->Trace('Processing complete.');
$scr->LOG->Info('Events examined: ' . $eventcount );
$scr->LOG->Info('Transformed: ' . $transformcount );
$scr->LOG->Info('Brochures: ' . $brochurecount );
$scr->LOG->Info('Dedups: ' . $dedupcount );

$scr->LOG->Trace("");
$scr->LOG->Info("Completed at " . $scr->scriptend->format('m/d/Y H:i:s'));
$scr->LOG->Info("Elapsed time " . $scr->scriptelapsed->format('%i:%S'));

$scr->LOG->Info("- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - \t");
$scr->LOG->Info("Step 1 elapsed: $step1elapsed");
$scr->LOG->Info("Step 2 elapsed: $step2elapsed");
$scr->LOG->Info("Step 3 elapsed: $step3elapsed");

// Clear the semaphore.
XperClearSemaphore($scr->SemaphoreId);

flush();

if ($DEBUG)
{
    $handle = fopen("php://stdin","r");
    $line = fgets($handle);
    fclose($handle);
}
die();
?>
